/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.game;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.block.entity.BlockEntityVolume;
import org.spongepowered.api.world.volume.game.ChunkVolume;
import org.spongepowered.api.world.volume.game.EnvironmentalVolume;
import org.spongepowered.api.world.volume.game.HeightAwareVolume;
import org.spongepowered.math.vector.Vector3i;

public interface Region<R extends Region<R>>
extends EnvironmentalVolume,
BiomeVolume.Streamable<R>,
BlockVolume.Streamable<R>,
BlockEntityVolume.Streamable<R>,
ChunkVolume,
HeightAwareVolume,
RandomProvider {
    public WorldType worldType();

    public WorldBorder border();

    public boolean isInBorder(Entity var1);

    default public boolean canSeeSky(Vector3i position) {
        return this.canSeeSky(position.getX(), position.getY(), position.getZ());
    }

    public boolean canSeeSky(int var1, int var2, int var3);

    default public boolean hasLiquid(Vector3i position) {
        return this.hasLiquid(position.getX(), position.getY(), position.getZ());
    }

    public boolean hasLiquid(int var1, int var2, int var3);

    public boolean containsAnyLiquids(AABB var1);

    public int skylightSubtracted();

    public int seaLevel();

    public boolean isCollisionBoxesEmpty(@Nullable Entity var1, AABB var2);

    default public boolean isBlockLoaded(int x, int y, int z) {
        return this.isBlockLoaded(x, y, z, true);
    }

    default public boolean isBlockLoaded(int x, int y, int z, boolean allowEmpty) {
        Vector3i chunkPos = Sponge.server().chunkLayout().forceToChunk(x, y, z);
        return this.isChunkLoaded(chunkPos.getX(), chunkPos.getY(), chunkPos.getZ(), allowEmpty);
    }

    default public boolean isBlockLoaded(Vector3i position) {
        Objects.requireNonNull(position);
        return this.isBlockLoaded(position.getX(), position.getY(), position.getZ(), true);
    }

    default public boolean isBlockLoaded(Vector3i position, boolean allowEmpty) {
        Objects.requireNonNull(position);
        return this.isBlockLoaded(position.getX(), position.getY(), position.getZ(), allowEmpty);
    }

    default public boolean isAreaLoaded(Vector3i position, int radius) {
        Objects.requireNonNull(position);
        return this.isAreaLoaded(position, radius, true);
    }

    default public boolean isAreaLoaded(Vector3i center, int radius, boolean allowEmpty) {
        Objects.requireNonNull(center);
        return this.isAreaLoaded(center.getX() - radius, center.getY() - radius, center.getZ() - radius, center.getX() + radius, center.getY() + radius, center.getZ() + radius, allowEmpty);
    }

    default public boolean isAreaLoaded(Vector3i from, Vector3i to) {
        return this.isAreaLoaded(from, to, true);
    }

    default public boolean isAreaLoaded(Vector3i from, Vector3i to, boolean allowEmpty) {
        return this.isAreaLoaded(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ(), allowEmpty);
    }

    public boolean isAreaLoaded(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);
}

