/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.stream;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocationCreator;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.volume.archetype.block.entity.BlockEntityArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeVolume;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.block.PhysicsAwareMutableBlockVolume;
import org.spongepowered.api.world.volume.block.entity.BlockEntityVolume;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.api.world.volume.stream.VolumeApplicator;

public final class VolumeApplicators {
    public static <M extends BlockVolume.Mutable<M>> VolumeApplicator<M, BlockState, Boolean> applyBlocks() {
        return (volume, element) -> volume.setBlock(element.position(), (BlockState)element.type());
    }

    public static <M extends PhysicsAwareMutableBlockVolume<M>> VolumeApplicator<M, BlockState, Boolean> applyBlocks(BlockChangeFlag flag) {
        Objects.requireNonNull(flag, "BlockChangeFlag cannot be null!");
        return (volume, element) -> volume.setBlock(element.position(), (BlockState)element.type(), flag);
    }

    public static <M extends BlockEntityVolume.Mutable<M>> VolumeApplicator<M, BlockEntity, Boolean> applyBlockEntities() {
        return (volume, element) -> {
            if (volume.setBlock(element.position(), ((BlockEntity)element.type()).block())) {
                volume.addBlockEntity(element.position(), (BlockEntity)element.type());
                return true;
            }
            return false;
        };
    }

    public static <M extends BlockEntityVolume.Mutable<M>> VolumeApplicator<M, Optional<? extends BlockEntity>, Boolean> applyOrRemoveBlockEntities() {
        return (volume, element) -> {
            Optional blockEntityOpt = (Optional)element.type();
            if (blockEntityOpt.isPresent()) {
                BlockEntity blockEntity = (BlockEntity)blockEntityOpt.get();
                if (volume.setBlock(element.position(), blockEntity.block())) {
                    volume.addBlockEntity(element.position(), blockEntity);
                    return true;
                }
                return false;
            }
            return volume.removeBlock(element.position());
        };
    }

    public static <M extends BlockVolume.Mutable<M>> VolumeApplicator<M, Optional<BlockState>, Boolean> applyOrRemoveBlockState() {
        return (volume, element) -> ((Optional)element.type()).map(blockState -> volume.setBlock(element.position(), (BlockState)blockState)).orElseGet(() -> volume.removeBlock(element.position()));
    }

    public static <M extends PhysicsAwareMutableBlockVolume<M>> VolumeApplicator<M, Optional<BlockState>, Boolean> applyOrRemoveBlockState(BlockChangeFlag flag) {
        return (volume, element) -> ((Optional)element.type()).map(blockState -> volume.setBlock(element.position(), (BlockState)blockState, flag)).orElseGet(() -> volume.removeBlock(element.position()));
    }

    public static <M extends LocationCreator<?, ? extends ServerLocation> & BlockEntityVolume.Mutable<M>> VolumeApplicator<M, BlockEntityArchetype, Optional<? extends BlockEntity>> applyBlockEntityArchetype() {
        return (volume, element) -> ((BlockEntityArchetype)element.type()).apply((ServerLocation)volume.location(element.position()));
    }

    public static <M extends BlockEntityArchetypeVolume.Mutable<M>> VolumeApplicator<M, BlockEntityArchetype, Boolean> applyBlockEntityArchetypes() {
        return (volume, element) -> {
            volume.addBlockEntity(element.position(), (BlockEntityArchetype)element.type());
            return true;
        };
    }

    public static <M extends EntityVolume.Mutable<M>> VolumeApplicator<M, Entity, Boolean> applyEntities() {
        return (volume, element) -> volume.spawnEntity((Entity)element.type());
    }

    public static <M extends BiomeVolume.Mutable<M>> VolumeApplicator<M, Biome, Boolean> applyBiomes() {
        return (volume, element) -> volume.setBiome(element.position(), (Biome)element.type());
    }

    public static <M extends LocationCreator<?, ? extends ServerLocation> & EntityVolume.Mutable<M>> VolumeApplicator<M, EntityArchetype, Optional<? extends Entity>> applyEntityArchetype() {
        return (volume, element) -> ((EntityArchetype)element.type()).apply((ServerLocation)volume.location(element.position()));
    }

    public static <M extends EntityArchetypeVolume.Mutable<M>> VolumeApplicator<M, EntityArchetype, Boolean> applyEntityArchetypes() {
        return (volume, element) -> {
            volume.addEntity((EntityArchetype)element.type(), element.position().toDouble());
            return true;
        };
    }

    private VolumeApplicators() {
    }
}

