/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.stream;

import java.util.Objects;
import java.util.function.Function;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslator;
import org.spongepowered.math.imaginary.Quaterniond;
import org.spongepowered.math.vector.Vector3i;

public final class VolumePositionTranslators {
    public static <W extends Volume, E> VolumePositionTranslator<W, E> identity() {
        return element -> element;
    }

    public static <W extends Volume> VolumePositionTranslator<W, BlockState> rotateBlocksOn(Vector3i center, Rotation rotation) {
        return VolumePositionTranslators.rotateOn(center, rotation, state -> state.rotate(rotation));
    }

    public static <W extends Volume> VolumePositionTranslator<W, Entity> rotateEntitiesOn(Vector3i center, Rotation rotation) {
        return VolumePositionTranslators.rotateOn(center, rotation, entity -> {
            entity.setRotation(entity.rotation().add(0.0f, (float)rotation.angle() / 360.0f, 0.0f));
            return entity;
        });
    }

    public static <W extends Volume> VolumePositionTranslator<W, BlockEntity> rotateBlockEntitiesOn(Vector3i center, Rotation rotation) {
        return VolumePositionTranslators.rotateOn(center, rotation, blockEntity -> blockEntity.rotate(rotation));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> rotateOn(Vector3i center, Rotation rotation, Function<E, E> elementRotation) {
        return element -> {
            Quaterniond q = Quaterniond.fromAngleDegAxis((float)rotation.angle(), (float)0.0f, (float)1.0f, (float)0.0f);
            Vector3i v = q.rotate(element.position().sub(center).toDouble()).toInt().add(center);
            return VolumeElement.of(element.volume(), elementRotation.apply(element.type()), v);
        };
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> relativeTo(Vector3i newOrigin) {
        return element -> VolumeElement.of(element.volume(), element.type(), element.position().add(newOrigin));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> offset(Vector3i min) {
        return element -> VolumeElement.of(element.volume(), element.type(), element.position().sub(min));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> position(Function<Vector3i, Vector3i> func) {
        Objects.requireNonNull(func, "Position function cannot be null!");
        return element -> VolumeElement.of(element.volume(), element.type(), (Vector3i)func.apply(element.position()));
    }

    public static <W extends Volume, E> VolumePositionTranslator<W, E> offsetPosition(Vector3i origin, Vector3i originalOrigin) {
        Vector3i diff = origin.sub(originalOrigin);
        return element -> VolumeElement.of(element.volume(), element.type(), element.position().add(diff));
    }

    private VolumePositionTranslators() {
    }
}

