/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.exception;

import com.google.common.base.Strings;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.exception.CommandException;

public class ArgumentParseException
extends CommandException {
    private static final long serialVersionUID = 820209656566192976L;
    private final String source;
    private final int position;

    public ArgumentParseException(@Nullable Component message, String source, int position) {
        super(message, true);
        this.source = source;
        this.position = position;
    }

    public ArgumentParseException(@Nullable Component message, Throwable cause, String source, int position) {
        super(message, cause, true);
        this.source = source;
        this.position = position;
    }

    @Override
    public @Nullable Component componentMessage() {
        @Nullable Component superText = super.componentMessage();
        if (this.source == null || this.source.isEmpty()) {
            return super.componentMessage();
        }
        if (superText == null) {
            return Component.text((String)this.annotatedPosition());
        }
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(superText)).append((Component)Component.newline())).append((Component)Component.text((String)this.annotatedPosition()))).build();
    }

    public @Nullable Component superText() {
        return super.componentMessage();
    }

    public String annotatedPosition() {
        String source = this.source;
        int position = this.position;
        if (source.length() > 80) {
            if (position >= 37) {
                int startPos = position - 37;
                int endPos = Math.min(source.length(), position + 37);
                source = endPos < source.length() ? "..." + source.substring(startPos, endPos) + "..." : "..." + source.substring(startPos, endPos);
                position -= 40;
            } else {
                source = source.substring(0, 77) + "...";
            }
        }
        return source + "\n" + Strings.repeat((String)" ", (int)position) + "^";
    }

    public int position() {
        return this.position;
    }

    public String sourceString() {
        return this.source;
    }
}

