/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.CopyableBuilder;

public final class DataTransactionResult {
    private static final DataTransactionResult SUCCESS_NODATA = DataTransactionResult.builder().result(Type.SUCCESS).build();
    private static final DataTransactionResult FAIL_NODATA = DataTransactionResult.builder().result(Type.FAILURE).build();
    private static final Collector<DataTransactionResult, Builder, DataTransactionResult> COLLECTOR = new Collector<DataTransactionResult, Builder, DataTransactionResult>(){

        @Override
        public Supplier<Builder> supplier() {
            return DataTransactionResult::builder;
        }

        @Override
        public BiConsumer<Builder, DataTransactionResult> accumulator() {
            return Builder::absorbResult;
        }

        @Override
        public BinaryOperator<Builder> combiner() {
            return (left, right) -> {
                left.absorbResult(right.build());
                return left;
            };
        }

        @Override
        public Function<Builder, DataTransactionResult> finisher() {
            return Builder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return ImmutableSet.of();
        }
    };
    final Type type;
    private final ImmutableList<Value.Immutable<?>> rejected;
    private final ImmutableList<Value.Immutable<?>> replaced;
    private final ImmutableList<Value.Immutable<?>> success;

    public static Collector<DataTransactionResult, Builder, DataTransactionResult> toTransaction() {
        return COLLECTOR;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DataTransactionResult successNoData() {
        return SUCCESS_NODATA;
    }

    public static DataTransactionResult successResult(Value.Immutable<?> value) {
        return DataTransactionResult.builder().success(value).result(Type.SUCCESS).build();
    }

    public static DataTransactionResult successReplaceResult(Value.Immutable<?> successful, Value.Immutable<?> replaced) {
        return DataTransactionResult.builder().result(Type.SUCCESS).success(successful).replace(replaced).build();
    }

    public static DataTransactionResult successReplaceResult(Collection<Value.Immutable<?>> successful, Collection<Value.Immutable<?>> replaced) {
        return DataTransactionResult.builder().success(successful).replace(replaced).result(Type.SUCCESS).build();
    }

    public static DataTransactionResult successRemove(Collection<Value.Immutable<?>> removed) {
        return DataTransactionResult.builder().replace(removed).result(Type.SUCCESS).build();
    }

    public static DataTransactionResult successRemove(Value.Immutable<?> removed) {
        return DataTransactionResult.builder().replace(removed).result(Type.SUCCESS).build();
    }

    public static DataTransactionResult failResult(Value.Immutable<?> value) {
        return DataTransactionResult.builder().reject(value).result(Type.FAILURE).build();
    }

    public static DataTransactionResult failResult(Iterable<Value.Immutable<?>> values) {
        return DataTransactionResult.builder().reject(values).result(Type.FAILURE).build();
    }

    public static DataTransactionResult failNoData() {
        return FAIL_NODATA;
    }

    public static DataTransactionResult errorResult(Value.Immutable<?> value) {
        return DataTransactionResult.builder().result(Type.ERROR).reject(value).build();
    }

    DataTransactionResult(Builder builder) {
        this.type = builder.resultType;
        this.rejected = builder.rejected != null ? ImmutableList.copyOf(builder.rejected) : ImmutableList.of();
        this.replaced = builder.replaced != null ? ImmutableList.copyOf(builder.replaced) : ImmutableList.of();
        this.success = builder.successful != null ? ImmutableList.copyOf(builder.successful) : ImmutableList.of();
    }

    public Type type() {
        return this.type;
    }

    public boolean isSuccessful() {
        return this.type() == Type.SUCCESS;
    }

    public List<Value.Immutable<?>> successfulData() {
        return this.success;
    }

    public <T, V extends Value<T>> Optional<Value.Immutable<T>> successfulValue(Key<V> key) {
        for (Value.Immutable<?> value : this.successfulData()) {
            if (value.key() != key) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public List<Value.Immutable<?>> rejectedData() {
        return this.rejected;
    }

    public <T, V extends Value<T>> Optional<Value.Immutable<T>> rejectedValue(Key<V> key) {
        for (Value.Immutable<?> value : this.rejectedData()) {
            if (value.key() != key) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public List<Value.Immutable<?>> replacedData() {
        return this.replaced;
    }

    public <T, V extends Value<T>> Optional<Value.Immutable<T>> replacedValue(Key<V> key) {
        for (Value.Immutable<?> value : this.replacedData()) {
            if (value.key() != key) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public void ifSuccessful(Consumer<List<Value.Immutable<?>>> consumer) {
        if (this.isSuccessful()) {
            consumer.accept((List<Value.Immutable<?>>)this.success);
        }
    }

    public <E extends Exception> void ifNotSuccessful(Supplier<E> supplier) throws E {
        if (!this.isSuccessful()) {
            throw (Exception)supplier.get();
        }
    }

    public String toString() {
        return new StringJoiner(", ", DataTransactionResult.class.getSimpleName() + "[", "]").add("type=" + (Object)((Object)this.type)).add("rejected=" + this.rejected).add("replaced=" + this.replaced).add("success=" + this.success).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTransactionResult that = (DataTransactionResult)o;
        return this.type == that.type && Objects.equals(this.rejected, that.rejected) && Objects.equals(this.replaced, that.replaced) && Objects.equals(this.success, that.success);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.rejected, this.replaced, this.success});
    }

    public static final class Builder
    implements org.spongepowered.api.util.Builder<DataTransactionResult, Builder>,
    CopyableBuilder<DataTransactionResult, Builder> {
        @MonotonicNonNull List<Value.Immutable<?>> rejected;
        @MonotonicNonNull List<Value.Immutable<?>> replaced;
        @MonotonicNonNull List<Value.Immutable<?>> successful;
        @MonotonicNonNull Type resultType;

        Builder() {
        }

        public Builder result(Type type) {
            this.resultType = Objects.requireNonNull(type);
            return this;
        }

        public Builder replace(Value.Immutable<?> value) {
            if (this.replaced == null) {
                this.replaced = new ArrayList();
            }
            this.replaced.add(Objects.requireNonNull(value));
            return this;
        }

        public Builder replace(Iterable<Value.Immutable<?>> values) {
            for (Value.Immutable<?> value : values) {
                this.replace(Objects.requireNonNull(value));
            }
            return this;
        }

        public Builder reject(Value.Immutable<?> value) {
            if (this.rejected == null) {
                this.rejected = new ArrayList();
            }
            this.rejected.add(Objects.requireNonNull(value));
            return this;
        }

        public Builder reject(Iterable<Value.Immutable<?>> values) {
            for (Value.Immutable<?> value : values) {
                this.reject(Objects.requireNonNull(value));
            }
            return this;
        }

        public Builder success(Value.Immutable<?> value) {
            if (this.successful == null) {
                this.successful = new ArrayList();
            }
            this.successful.add(Objects.requireNonNull(value));
            return this;
        }

        public Builder success(Iterable<Value.Immutable<?>> values) {
            for (Value.Immutable<?> value : values) {
                this.success(Objects.requireNonNull(value));
            }
            return this;
        }

        public Builder absorbResult(DataTransactionResult result) {
            if (this.resultType == null) {
                this.resultType = result.type();
            } else if (this.resultType.compareTo(result.type()) < 0) {
                this.resultType = result.type();
            }
            ArrayList newSuccessful = new ArrayList();
            ArrayList newReplaced = new ArrayList();
            ArrayList newRejected = new ArrayList();
            if (this.successful != null) {
                block0: for (Value.Immutable<?> value : this.successful) {
                    for (Value.Immutable<?> immutable : result.rejectedData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newRejected.add(immutable);
                        continue block0;
                    }
                    for (Value.Immutable<Object> immutable : result.replacedData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newReplaced.add(value);
                        continue block0;
                    }
                    for (Value.Immutable<Object> immutable : result.successfulData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newSuccessful.add(immutable);
                        continue block0;
                    }
                    newSuccessful.add(value);
                }
            }
            if (this.replaced != null) {
                block4: for (Value.Immutable<?> value : this.replaced) {
                    for (Value.Immutable<Object> immutable : result.rejectedData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newRejected.add(immutable);
                        continue block4;
                    }
                    for (Value.Immutable<Object> immutable : result.replacedData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newReplaced.add(value);
                        continue block4;
                    }
                    for (Value.Immutable<Object> immutable : result.successfulData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newSuccessful.add(immutable);
                        continue block4;
                    }
                    newReplaced.add(value);
                }
            }
            if (this.rejected != null) {
                block8: for (Value.Immutable<?> value : this.rejected) {
                    for (Value.Immutable<Object> immutable : result.rejectedData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newRejected.add(immutable);
                        continue block8;
                    }
                    for (Value.Immutable<Object> immutable : result.replacedData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newReplaced.add(value);
                        continue block8;
                    }
                    for (Value.Immutable<Object> immutable : result.successfulData()) {
                        if (!value.key().equals(immutable.key())) continue;
                        newSuccessful.add(immutable);
                        continue block8;
                    }
                    newRejected.add(value);
                }
            }
            block12: for (Value.Immutable<?> value : result.successfulData()) {
                for (Value.Immutable<Object> immutable : newRejected) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block12;
                }
                for (Value.Immutable<Object> immutable : newReplaced) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block12;
                }
                for (Value.Immutable<Object> immutable : newSuccessful) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block12;
                }
                newSuccessful.add(value);
            }
            block16: for (Value.Immutable<?> value : result.rejectedData()) {
                for (Value.Immutable<Object> immutable : newRejected) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block16;
                }
                for (Value.Immutable<Object> immutable : newReplaced) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block16;
                }
                for (Value.Immutable<Object> immutable : newSuccessful) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block16;
                }
                newRejected.add(value);
            }
            block20: for (Value.Immutable<?> value : result.replacedData()) {
                for (Value.Immutable<Object> immutable : newRejected) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block20;
                }
                for (Value.Immutable<Object> immutable : newReplaced) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block20;
                }
                for (Value.Immutable<Object> immutable : newSuccessful) {
                    if (!value.key().equals(immutable.key())) continue;
                    continue block20;
                }
                newReplaced.add(value);
            }
            this.replaced = newReplaced;
            this.rejected = newRejected;
            this.successful = newSuccessful;
            return this;
        }

        public DataTransactionResult build() {
            if (this.resultType == null) {
                throw new IllegalStateException("ResultType must be set!");
            }
            return new DataTransactionResult(this);
        }

        @Override
        public Builder from(DataTransactionResult value) {
            this.resultType = value.type;
            this.rejected = new ArrayList(value.rejectedData());
            this.replaced = new ArrayList(value.replacedData());
            this.successful = new ArrayList(value.successfulData());
            return this;
        }

        @Override
        public Builder reset() {
            this.rejected = null;
            this.replaced = null;
            this.successful = null;
            this.resultType = null;
            return this;
        }
    }

    public static enum Type {
        UNDEFINED,
        SUCCESS,
        FAILURE,
        ERROR,
        CANCELLED;

    }
}

