/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.effect.potion;

import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.util.CopyableBuilder;

public interface PotionEffect
extends DataSerializable {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static PotionEffect of(PotionEffectType type, int amplifier, int duration) {
        return PotionEffect.builder().potionType(type).amplifier(amplifier).duration(duration).build();
    }

    public static PotionEffect of(Supplier<? extends PotionEffectType> type, int amplifier, int duration) {
        return PotionEffect.builder().potionType(type).amplifier(amplifier).duration(duration).build();
    }

    public PotionEffectType type();

    public int duration();

    public int amplifier();

    public boolean isAmbient();

    public boolean showsParticles();

    public boolean showsIcon();

    public static interface Builder
    extends org.spongepowered.api.util.Builder<PotionEffect, Builder>,
    CopyableBuilder<PotionEffect, Builder>,
    DataBuilder<PotionEffect> {
        public Builder potionType(PotionEffectType var1);

        default public Builder potionType(Supplier<? extends PotionEffectType> potionEffectType) {
            return this.potionType(potionEffectType.get());
        }

        public Builder duration(int var1);

        public Builder amplifier(int var1) throws IllegalArgumentException;

        public Builder ambient(boolean var1);

        public Builder showParticles(boolean var1);

        public Builder showIcon(boolean var1);

        public PotionEffect build() throws IllegalStateException;
    }
}

