/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.scheduler;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.plugin.PluginContainer;

public interface Task {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public PluginContainer plugin();

    public Duration delay();

    public Duration interval();

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Task, Builder>,
    CopyableBuilder<Task, Builder> {
        default public Builder execute(Runnable runnable) {
            return this.execute((ScheduledTask task) -> runnable.run());
        }

        public Builder execute(Consumer<ScheduledTask> var1);

        default public Builder delay(long delay, TemporalUnit unit) {
            return this.delay(Duration.of(delay, unit));
        }

        default public Builder delay(long delay, TimeUnit unit) {
            return this.delay(unit.toNanos(delay), ChronoUnit.NANOS);
        }

        public Builder delay(Ticks var1);

        public Builder delay(Duration var1);

        public Builder interval(Duration var1);

        default public Builder interval(long interval, TemporalUnit unit) {
            return this.interval(Duration.of(interval, unit));
        }

        default public Builder interval(long interval, TimeUnit unit) {
            return this.interval(unit.toNanos(interval), ChronoUnit.NANOS);
        }

        public Builder interval(Ticks var1);

        public Builder plugin(PluginContainer var1);

        public Task build();
    }
}

