/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.context;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.context.Context;

@FunctionalInterface
public interface ContextCalculator {
    public static ContextCalculator forSingleContext(String key, Function<Cause, String> valueFunction) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valueFunction, "valueFunction");
        return (target, accumulator) -> {
            String value = (String)valueFunction.apply(target);
            if (value != null) {
                accumulator.accept(new Context(key, value));
            }
        };
    }

    public void accumulateContexts(Cause var1, Consumer<Context> var2);
}

