/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.util.Objects;

public final class Angle {
    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    private final double degrees;
    private final double radians;

    public static Angle fromDegrees(double degrees) {
        return new Angle(degrees, degrees * (Math.PI / 180));
    }

    public static Angle fromRadians(double radians) {
        return new Angle(radians / (Math.PI / 180), radians);
    }

    private Angle(double degrees, double radians) {
        this.degrees = degrees;
        this.radians = radians;
    }

    public double degrees() {
        return this.degrees;
    }

    public double radians() {
        return this.radians;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Angle angle = (Angle)o;
        return Double.compare(angle.degrees, this.degrees) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.degrees);
    }
}

