/*
 * This file is part of SpongeAPI, licensed under the MIT License (MIT).
 *
 * Copyright (c) SpongePowered <https://www.spongepowered.org>
 * Copyright (c) contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.spongepowered.api.world.chunk;

import org.spongepowered.api.registry.DefaultedRegistryValue;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.World;

/**
 * Represents the state of a {@link Chunk} that can exist
 * through various stages of the game, including but not limited to:
 * <ul><li>Chunk in the process of being generated</li>
 * <li>Chunk being deserialized from storage and being prepared for addition to a {@link World}</li>
 * <li>{@link WorldChunk}s already existing and loaded in a {@link World}</li>
 * </ul>
 */
@CatalogedBy(ChunkStates.class)
public interface ChunkState extends DefaultedRegistryValue {

    /**
     * Checks whether this state is considered "after"
     * the provided {@link ChunkState}. Usually used as a check for
     * whether the {@link Chunk} providing this state is
     * considered "usable" for consumers of {@link Chunk}s with
     * a specific {@link ChunkState} range.
     *
     * @param state The chunk state
     * @return True if this state is after the provided state
     */
    boolean isAfter(ChunkState state);

}
